/**
 * Custom scripts needed for the colorpicker, image button selectors,
 * and navigation tabs.
 */

jQuery(document).ready(function($) {

	$('.wcmd_multiselect').find('select').select2();
	//$("#section-wpmlmenu").children("select").select2();

	//Form Submit
	$('body').on('click', '#wcmd_optionsframework-submit .save-settings', function(e) {
		e.preventDefault();
		$('form#wcmd_form_settings').submit();
	});

	if( wcmdOption.use_predefined_coupon == 'yes' ) {
		hide_Custom_Coupon_Settings();
	}
	else {
		show_Custom_Coupon_Settings();
	}

	function hide_Custom_Coupon_Settings() {
		$('#section-wcmd_predefined_coupon').show();
		$('#section-wcmd_dis_type').hide();
		$('#section-wcmd_prefix').hide();
		$('#section-wcmd_code_length').hide();
		$('#section-wcmd_amount').hide();
		$('#section-wcmd_shipping').hide();
		$('#section-wcmd_sale').hide();
		$('#section-wcmd_products').hide();
		$('#section-wcmd_exclude_products').hide();
		$('#section-wcmd_categories').hide();
		$('#section-wcmd_exclude_categories').hide();
		$('#section-wcmd_days').hide();
		$('#section-wcmd_date_format').hide();
		$('#section-wcmd_min_purchase').hide();
		$('#section-wcmd_max_purchase').hide();
	}

	function show_Custom_Coupon_Settings() {
		$('#section-wcmd_predefined_coupon').hide();
		$('#section-wcmd_dis_type').show();
		$('#section-wcmd_prefix').show();
		$('#section-wcmd_code_length').show();
		$('#section-wcmd_amount').show();
		$('#section-wcmd_shipping').show();
		$('#section-wcmd_sale').show();
		$('#section-wcmd_products').show();
		$('#section-wcmd_exclude_products').show();
		$('#section-wcmd_categories').show();
		$('#section-wcmd_exclude_categories').show();
		$('#section-wcmd_days').show();
		$('#section-wcmd_date_format').show();
		$('#section-wcmd_min_purchase').show();
		$('#section-wcmd_max_purchase').show();
	}

	//Show Predefined Coupons sections
	$('body').on('change', '#wcmd_use_coupons_from', function() {
		if( $(this).is(':checked') ) {
			hide_Custom_Coupon_Settings();
		}
		else {
			show_Custom_Coupon_Settings();
		}
	});

	//Reset Form
	$('body').on('click', '#wcmd_optionsframework-submit .reset-settings', function(e) {
		var ConfirmString = confirm(wcmdOption.reset_text);
		
		if( ConfirmString == true ) {
			$('form#wcmd_form_settings').find('.reset-button.wcmd-reset-button').trigger('click');
		}
		
	});

	$(".ajax_products").find('.wcmd-select2').select2({
		minimumInputLength: $( this ).data( 'minimum_input_length' ) ? $( this ).data( 'minimum_input_length' ) : '3',
     ajax: {
       url: wcmdOption.ajaxurl,
     	  dataType: 'json',
     	  quietMillis: 250,
     	  data: function (params) {
      	  return {
        	 q: params.term, // search query
        	 action: 'wcmd_ajax_products' // AJAX action for admin-ajax.php
      		};
    		},
        
        processResults: function( data ) {
				var terms = [];
							if ( data ) {
								$.each( data, function( id, text ) {
									terms.push( { id: id, text: text } );
								});
							}
							return {
								results: terms
							};
			},
			cache: true
		},
	 });

	// Loads the color pickers
	if (typeof $.fn.wpColorPicker !== 'undefined') {
	    var calcLuminance = function calcLuminance(rgb) {
			var c = rgb.substring(1);

			var _rgb = parseInt(c, 16);

			var r = _rgb >> 16 & 0xff;
			var g = _rgb >> 8 & 0xff;
			var b = _rgb >> 0 & 0xff;
			return 0.2126 * r + 0.7152 * g + 0.0722 * b;
	    };

	    var formColor = jQuery( '#wcmd_optionsframework' ).find( ".form-control.form-color" );

	    $( formColor ).each(function () {
			var picker = $( this );
			var pickerWrap = $( this ).closest( '.wprmenu-color-picker' );
			var eyedropper = pickerWrap.find( '.eyedropper' );
			var section = $( this ).closest( '.section-color' );
			picker.css( 'background-color', picker.val() );

			if ( calcLuminance( picker.val() ) > 175 ) {
				picker.css( 'color', '#000000' );
			}

			picker.iris({
				mode: 'hsv',
				target: $( this ).parent().parent(),
				change: function change( event, ui ) {
					if ( calcLuminance( ui.color.toCSS() ) > 175 ) {
						$( this ).css( 'color', '#000000' );
					} 
					else {
						$( this ).css( 'color', '' );
					}
					$( this ).css( 'background-color', ui.color.toCSS() );
				}
			});

			section.on('click',  function(e) {
				e.preventDefault();
				if(!pickerWrap.is(e.target) && pickerWrap.has(e.target).length === 0){
					picker.iris( 'hide' );
					section.removeClass('active');
				}
			});
			pickerWrap.on( 'click', '.iris-square-value' , function (e) {
				e.preventDefault();
				picker.iris( 'toggle' );
				section.toggleClass('active');
			});

			eyedropper.on( 'click', function (e) {
				e.preventDefault();
				picker.iris( 'toggle' );
				section.toggleClass('active');
			});

			picker.on( 'focusin', function () {
				picker.iris( 'show' );
				section.toggleClass('active');
			});

			
	    });
	}
	$('.of-color').wpColorPicker();

	$('[data-toggle="tooltip"]').tooltip();

	// Image Options
	$('.of-radio-img-img').click( function(){
		$(this).parent().parent().find('.of-radio-img-img').removeClass('of-radio-img-selected');
		$(this).addClass('of-radio-img-selected');
	} );

	$('.of-radio-img-label').hide();
	$('.of-radio-img-img').show();
	$('.of-radio-img-radio').hide();

	if( $('#wcmd_optionsframework').length ) {
		var SettingsHeight = $('#wcmd_optionsframework').find('#options-group-1').innerHeight();
		if( SettingsHeight > 0 ) {
			//$('#wcmd_optionsframework-wrap').find('.queries-holder').height(SettingsHeight+'px');
		}
	}

	// Loads tabbed sections if they exist
	if ( $( '.nav-tab-wrapper').length > 0 ) {
		options_framework_tabs();
	}

	function options_framework_tabs() {
		var $group = $('.group'),
			$navtabs = $('.mg-navtabs-wrapper a'),
			active_tab = '';

		// Hides all the .group sections to start
		$group.hide();

		// Find if a selected tab is saved in localStorage
		if (  typeof( localStorage ) != 'undefined'  ) {
			active_tab = localStorage.getItem( 'active_tab' );
		}

		// If active tab is saved and exists, load it's .group
		if ( active_tab != '' && $( active_tab ).length ) {
			$(active_tab).fadeIn();
			$(active_tab + '-tab').addClass('nav-tab-active');
		} else {
			$('.group:first').fadeIn();
			$('.nav-tab-wrapper a:first').addClass('nav-tab-active');
		}

		// Bind tabs clicks
		$navtabs.click( function( e ) {

			e.preventDefault();

			// Remove active class from all tabs
			$navtabs.removeClass('nav-tab-active');

			$(this).addClass('nav-tab-active').blur();

			if (typeof( localStorage ) != 'undefined') {
				localStorage.setItem('active_tab', $(this).attr('href'));
			}

			var selected = $(this).attr('href');

			$group.hide();
			$(selected).fadeIn();
		} );
	}

	$('body').on('click', 'a.wcmd-update-database' , function(e) {
		e.preventDefault();
		$(this).text(wcmdOption.loader_text);
		
		$.ajax({
			type 		: 'POST',
			url  		: wcmdOption.ajaxurl,
			data 		: 'action=wcmd_database_update&security='+wcmdOption.ajax_nonce,
			success	: function(response) {
				if( response.status == 'success' ) {
					window.location.reload();
				}
			}
		});
	});

	

	//Verify MailChimp API Key by doing click here
	$('body').on('click', 'a.verify-wcmd-mailchimp-api-key', function(e) {
		e.preventDefault();
		var MailChimpAPIKey = $(this).parents('#section-wcmd_api_key').find('#wcmd_api_key').val();

		if( MailChimpAPIKey == '' ) {
			Swal({
				type  : 'error',
				title : wcmdOption.empty_api_key_error,
			});
			return false;
		}

		$.post(
			wcmdOption.ajaxurl,
			{
				MailChimpAPIKey : MailChimpAPIKey,
				action					: 'wcmd_verify_api_key',
				security				: wcmdOption.wcmd_verify_api_nonce,
			},
			function (data) {
				if( data.status == false ) {
					Swal({
						type  : 'error',
						title : wcmdOption.empty_api_key_error,
					});
				}
				else {
					Swal({
						type  : 'success',
						title : wcmdOption.valid_api_key,
					});
				}
			})
	});

	//Get MailChimp List/Audience Ids
	$('body').on('click', 'a.wcmd-get-lists', function(e) {
		e.preventDefault();
		var MailChimpAPIKey = $(this).parents('.mailchimpsettings').find('input#wcmd_api_key').val();

		if( MailChimpAPIKey == '' ) {
			alert(wcmdOption.empty_api_error);
			return false;
		}

		$.post(
			wcmdOption.ajaxurl,
			{
				apikey : MailChimpAPIKey,
				action : 'wcmd_get_mailchimp_lists',
				security : wcmdOption.wcmd_lists_nonce,
			},
			function response(data) {
				var ListHtml = ''; 
				$.each(data, function(key, item){
					ListHtml += '<option value="'+key+'">'+item+'</option>'; 
				});
				$('#section-wcmd_list_id').find('#wcmd_list_id').html(ListHtml);
			}
		)

	});

	//Add and Verify Web Hook
	$('body').on('click', 'a.wcmd_verify_webhook', function(e) {
		e.preventDefault();
		var MailChimpAPIKey = $(this).parents('.mailchimpsettings').find('input#wcmd_api_key').val();
		var MailChimpList = $(this).parents('.mailchimpsettings').find('#wcmd_list_id').val();
		var Webhook_url = $(this).parents('#section-wcmd_webhook_url').find('#wcmd_webhook_url').val();

		if( Webhook_url !== '' && (MailChimpAPIKey == '' || MailChimpList == '' )  ) {
			Swal({
				type  : 'error',
				title : wcmdOption.empty_api_list_id,
			});
			return false;
		}

		$.post(
			wcmdOption.ajaxurl,
			{
				MailChimpAPIKey : MailChimpAPIKey,
				MailChimpList 	: MailChimpList,
				WebHookUrl 		: Webhook_url,
				action			: 'wcmd_verify_webhook',
				security		: wcmdOption.wcmd_verify_webhook_nonce,
			},
			function response(data) {
				Swal({
					type  : data.message_type,
					title : data.message,
				});
			}
		)

	});


	//Add scroll menu settings
	var ButtonActions = $('#wcmd_optionsframework-submit').offset().top;

	$(window).scroll(function() {
		var currentScroll = $(window).scrollTop();

		if (currentScroll >= ButtonActions) {           
    	$('#wcmd_optionsframework-submit').css({
      	position: 'fixed',
        top: '38px',
        width: '16%',
      });
    } else {                                   // apply position: static
    	$('#wcmd_optionsframework-submit').css({                      // if you scroll above it
      	position: 'relative',
        top: '0px',
        width: '100%',
      });
    }
	});
});